<?php

namespace App\Http\Controllers\Site\Assessment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;
use App\Models\Site\Assessment\SiteAssessmentDeclare;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudentSubject;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentResultDetail;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;

class SiteBaseAssessmentResultReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Subject Assesment Topic';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getAssessmentDeclarListForResult(Request $requests){
        $data = $requests->all();
       
        $assessment_declared_ids=SiteAssessmentDeclare::where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->where('status', true)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('id')
            ->unique();


        $declared_ids=SiteStudentAssessmentResultDetail::whereIn('assessment_declare_id', $assessment_declared_ids)
            ->pluck('assessment_declare_id')
            ->unique();

        $assessmentDeclareList=SiteAssessmentDeclare::with('assessment')->whereIn('id', $declared_ids)->where('status',true)->get();

        return $assessmentDeclareList;

    }

    public function getAssessmentTypeListForResult(Request $requests){

        $type_ids=SiteStudentAssessmentResultDetail::where('assessment_declare_id', $requests->assessment_declare_id)
            ->pluck('assessment_type_id')
            ->unique();

        $assessmentTypeList=AssessmentType::whereIn('id', $type_ids)->get();

        return $assessmentTypeList;

    }

    public function getSiteStudentList(Request $requests){

       
        $studentList=$this->studentHistoryList($requests);
    

        return $studentList;

    }

    private function studentHistoryList(Request $requests){

        $data=$requests->all();
       
        $studentList=StudentHistory::where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_class_id')
            ->get();

      
        return $studentList;

    }

    public function getSiteAssessmentStudentResultDetails(Request $request){
        $assessmentResultDetails=SiteStudentAssessmentResultDetail::where('assessment_declare_id', $request->assessment_declare_id)
                ->where('assessment_type_id',$request->assessment_type_id)
                ->whereIn('student_history_id',$request->select_student_user_ids)
                ->get();
                dd($assessmentResultDetails);
    }
}
